/* 
 *  Arnold emulator (c) Copyright, Kevin Thacker 1995-2001
 *  
 *  This file is part of the Arnold emulator source code distribution.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "Specific.h"
#include "../../cpc/packedimage.h"
#include "../../special/filter/hq2x.h"
#include "../../special/filter/scale2x.h"

/* current graphics format */
extern GRAPHICS_FORMAT  CurrentGraphicsFormat;

static GRAPHICS_BUFFER_INFO BufferInfo;

GRAPHICS_BUFFER_INFO *Host_GetGraphicsBufferInfo()
{
	return &BufferInfo;
}

#include "../../cpc/host.h"
#include "directx/dd.h"
#include "directx/graphlib.h"
#include "directx/ds.h"
#include <direct.h>
#include "../../cpc_modified/arnold.h"
#include "cpcemu.h"
#include "../../cpc/fdd.h"
#include "directx\MyDI.h"
#include "../../cpc/autotype.h"
#include "../../cpc/cpc.h"
#include "../../cpc/render.h"

#include "ifacegen.h"
#include "../../cpc/host.h"

extern APP_DATA AppData;

//from render.c
void    Render_SetRenderingAccuracy(int Accuracy);
void Render_TrueColourRGB_Setup(void);
void Render_Paletted_Setup(void);

struct GRAPHICS_BUFFER_COLOUR_FORMAT BufferColourFormat;
static SOUND_PLAYBACK_FORMAT SoundFormat;
static 	DDSURFACEDESC SurfaceDesc;

void DisplaySpeed(int fps);

BOOL Host_SetDisplay(int Type, int Width, int Height, int Depth)
{
	if (Type == DISPLAY_TYPE_WINDOWED)
	{
		MyApp_SetWindowed(Width, Height);
	}
	else
	{
		MyApp_SetFullScreen(Width, Height);
	}

	return DD_SetVideoMode(Width, Height, Depth, (Type!=DISPLAY_TYPE_WINDOWED));
}


struct GRAPHICS_BUFFER_COLOUR_FORMAT *Host_GetGraphicsBufferColourFormat()
{
//		DDSURFACEDESC SurfaceDesc;

		MODE_DETAILS ModeDetails;

		DD_ExamineMode(&ModeDetails);

//		BufferInfo.Height = SurfaceDesc.dwHeight;
//		BufferInfo.Width = SurfaceDesc.dwWidth;
//#ifdef _MSC_VER
//		BufferInfo.Pitch = SurfaceDesc.lPitch;
//#else
//		BufferInfo.Pitch = SurfaceDesc.u1.lPitch;
//#endif
//		BufferInfo.pSurface = SurfaceDesc.lpSurface;

		BufferColourFormat.BPP = ModeDetails.BPP;

		BufferColourFormat.Red.BPP = ModeDetails.RedBPP;
		BufferColourFormat.Red.Mask = ModeDetails.RedMask;
		BufferColourFormat.Red.Shift = ModeDetails.RedShift;

		BufferColourFormat.Green.BPP = ModeDetails.GreenBPP;
		BufferColourFormat.Green.Mask = ModeDetails.GreenMask;
		BufferColourFormat.Green.Shift = ModeDetails.GreenShift;

		BufferColourFormat.Blue.BPP = ModeDetails.BlueBPP;
		BufferColourFormat.Blue.Mask = ModeDetails.BlueMask;
		BufferColourFormat.Blue.Shift = ModeDetails.BlueShift;

		return (GRAPHICS_BUFFER_COLOUR_FORMAT*) &BufferColourFormat;
}



BOOL	Host_LockGraphicsBuffer(void)
{
	BOOL State;

	State = DD_GetSurfacePtr(&SurfaceDesc);

	if (State)
	{
		MODE_DETAILS ModeDetails;

		DD_ExamineMode(&ModeDetails);

		BufferInfo.Height = SurfaceDesc.dwHeight;
		BufferInfo.Width = SurfaceDesc.dwWidth;

		BufferInfo.Pitch = SurfaceDesc.lPitch;

		BufferInfo.pSurface = (unsigned char *)SurfaceDesc.lpSurface;

		BufferColourFormat.BPP = ModeDetails.BPP;

		BufferColourFormat.Red.BPP = ModeDetails.RedBPP;
		BufferColourFormat.Red.Mask = ModeDetails.RedMask;
		BufferColourFormat.Red.Shift = ModeDetails.RedShift;

		BufferColourFormat.Green.BPP = ModeDetails.GreenBPP;
		BufferColourFormat.Green.Mask = ModeDetails.GreenMask;
		BufferColourFormat.Green.Shift = ModeDetails.GreenShift;

		BufferColourFormat.Blue.BPP = ModeDetails.BlueBPP;
		BufferColourFormat.Blue.Mask = ModeDetails.BlueMask;
		BufferColourFormat.Blue.Shift = ModeDetails.BlueShift;

	}

	return State;
}


void	Host_UnlockGraphicsBuffer(void)
{
	DD_ReturnSurfacePtr(&SurfaceDesc);
}

void	Host_SwapGraphicsBuffers(void)
{
	DD_Flip();
}

void	Host_SetPaletteEntry(int Index, unsigned char R, unsigned char G, unsigned char B)
{
	DD_SetPaletteEntry(Index, R, G, B);
}

//void	Host_WriteDataToSoundBuffer(unsigned char *pData, unsigned long Length)
//{
//		DS_WriteBufferForSoundPlayback(pData,Length);
//}

BOOL	Host_AudioPlaybackPossible(void)
{
	return DS_AudioActive();
}

unsigned long	Host_GetCurrentTimeInMilliseconds(void)
{
	return timeGetTime();
}


SOUND_PLAYBACK_FORMAT *Host_GetSoundPlaybackFormat(void)
{
	SoundFormat.NumberOfChannels = DS_GetSampleChannels();
	SoundFormat.BitsPerSample = DS_GetSampleBits();
	SoundFormat.Frequency = DS_GetSampleRate();

	return &SoundFormat;
}

BOOL	Host_ProcessSystemEvents(void)
{
	/* process system events. If QUIT has been selected, then break out of loop */
	return WinApp_ProcessSystemEvents();
}

static void	DoDriveLEDIndicator(int Drive, BOOL State)
{
	if (State)
	{
//		ScrollLock_Set(TRUE);
	}
	else
	{
//		ScrollLock_Set(FALSE);
	}
}


/*void	Host_SetDirectory(char *Directory)
{
	_tchdir(Directory);
}
*/


BOOL Host_LockAudioBuffer(unsigned char **ppBlock1, unsigned long *pBlock1Size, unsigned char **ppBlock2, unsigned long *pBlock2Size, unsigned long BlockSize)
{
	return DS_LockAudioBuffer(ppBlock1, pBlock1Size, ppBlock2, pBlock2Size, BlockSize);
}

void Host_UnLockAudioBuffer(void)
{
	DS_UnLockAudioBuffer();
}

void Host_ClearAudioBuffer(void)
{
	DS_ClearBuffer();
}


void DrawDisplay(void)
{

	//if ((SurfaceDesc==NULL) || (m_pRenderer==NULL)) return;

	void *pPixels = NULL;
	unsigned char * pNewSurface = 0;

	RENDER_BUFFER_INFO BufferInfo;

	//DD_ClearScreenDisplay();

	if (Host_LockGraphicsBuffer())  
	{
		GRAPHICS_BUFFER_INFO *pGraphicsBufferInfo = Host_GetGraphicsBufferInfo();

		BufferInfo.pSurface = pGraphicsBufferInfo->pSurface;
		BufferInfo.SurfaceWidth = pGraphicsBufferInfo->Width;
		BufferInfo.SurfaceHeight = pGraphicsBufferInfo->Height;
		BufferInfo.SurfacePitch = pGraphicsBufferInfo->Pitch;
	    BufferInfo.CPCOffsetX = 0;
		BufferInfo.CPCOffsetY = 0;

		if (BufferInfo.pSurface!=NULL)
		{
			/* dump whole display to screen */
			Render_DumpDisplay(&BufferInfo);
		}

		//apply filter ?
#if 0
		{
			pNewSurface = (unsigned char *)malloc((BufferInfo.SurfacePitch * BufferInfo.SurfaceHeight));
			//hq2x_32(MemBuffer,Buffer,640,480,640*4);
			//The last parameter (BpL) means bytes-per-line, the same thing as pitch.
			hq2x_32(BufferInfo.pSurface, pNewSurface, BufferInfo.SurfaceWidth,BufferInfo.SurfaceHeight, BufferInfo.SurfacePitch );
			BufferInfo.pSurface=pNewSurface;
		}
#endif

		/* unlock surface */
		Host_UnlockGraphicsBuffer();

		//Add item on screen
		DisplayText();

		//chnage title in windowed mode
		if (AppData.Windowed) DisplaySpeed(GetAverageSpeed());

		/* flip screen (in windowed mode performs a blit) */
		Host_SwapGraphicsBuffers();

		if (pNewSurface) free(pNewSurface);

	}

}

BOOL Render_SetDisplayFullScreen(int Width, int Height, int Depth)
{
        
        /* not recommended for any res as low as 320x240 */
 
        int ScreenResX = Width;
        int ScreenResY = Height;
        int ScreenDepth = Depth;

        //Render_SetRenderingAccuracy(RENDERING_ACCURACY_HIGH);
		Render_SetRenderingAccuracy(RENDERING_ACCURACY_HIGHER);

        if (Host_SetDisplay(DISPLAY_TYPE_FULLSCREEN,ScreenResX,ScreenResY,ScreenDepth))
        {
                struct GRAPHICS_BUFFER_COLOUR_FORMAT   *pGraphicsBufferColourFormat = Host_GetGraphicsBufferColourFormat();

                CurrentGraphicsFormat.BPP = pGraphicsBufferColourFormat->BPP;
                
                CurrentGraphicsFormat.Red.BPP = pGraphicsBufferColourFormat->Red.BPP;
                CurrentGraphicsFormat.Red.Mask = pGraphicsBufferColourFormat->Red.Mask;
                CurrentGraphicsFormat.Red.Shift = pGraphicsBufferColourFormat->Red.Shift;
                
                CurrentGraphicsFormat.Green.BPP = pGraphicsBufferColourFormat->Green.BPP;
                CurrentGraphicsFormat.Green.Mask = pGraphicsBufferColourFormat->Green.Mask;
                CurrentGraphicsFormat.Green.Shift = pGraphicsBufferColourFormat->Green.Shift;
                
                CurrentGraphicsFormat.Blue.BPP = pGraphicsBufferColourFormat->Blue.BPP;
                CurrentGraphicsFormat.Blue.Mask = pGraphicsBufferColourFormat->Blue.Mask;
                CurrentGraphicsFormat.Blue.Shift = pGraphicsBufferColourFormat->Blue.Shift;

				if (CurrentGraphicsFormat.BPP!=8)
				{
					Render_TrueColourRGB_Setup();
				}
				else
				{
					Render_Paletted_Setup();
				}

                //pRender_DumpScreen = Render_DumpScreen4;
#if 0
				if (InitialiseRender(ScreenResX,ScreenResY, CurrentGraphicsFormat.BPP))
				{
					return TRUE;
				}
#endif
				Render_SetGraphicsBufferColourFormat(&BufferColourFormat, ScreenResX,ScreenResY);

				return TRUE;
        }

        return FALSE;
}

BOOL    Render_SetDisplayWindowed(int Width, int Height)
{
        int ScreenWidth, ScreenHeight;

		Render_GetWindowedDisplayDimensions(&ScreenWidth, &ScreenHeight);

		if ((Width > 0) && (Height > 0))
		{
			ScreenWidth = Width;
			ScreenHeight = Height;
		}
		else
		{
			Render_GetWindowedDisplayDimensions(&ScreenWidth, &ScreenHeight);
		}
        
        if (Host_SetDisplay(DISPLAY_TYPE_WINDOWED,ScreenWidth, ScreenHeight,0))
        {
                struct GRAPHICS_BUFFER_COLOUR_FORMAT   *pGraphicsBufferColourFormat = Host_GetGraphicsBufferColourFormat();

                CurrentGraphicsFormat.BPP = pGraphicsBufferColourFormat->BPP;
                
                CurrentGraphicsFormat.Red.BPP = pGraphicsBufferColourFormat->Red.BPP;
                CurrentGraphicsFormat.Red.Mask = pGraphicsBufferColourFormat->Red.Mask;
                CurrentGraphicsFormat.Red.Shift = pGraphicsBufferColourFormat->Red.Shift;
                
                CurrentGraphicsFormat.Green.BPP = pGraphicsBufferColourFormat->Green.BPP;
                CurrentGraphicsFormat.Green.Mask = pGraphicsBufferColourFormat->Green.Mask;
                CurrentGraphicsFormat.Green.Shift = pGraphicsBufferColourFormat->Green.Shift;
                
                CurrentGraphicsFormat.Blue.BPP = pGraphicsBufferColourFormat->Blue.BPP;
                CurrentGraphicsFormat.Blue.Mask = pGraphicsBufferColourFormat->Blue.Mask;
                CurrentGraphicsFormat.Blue.Shift = pGraphicsBufferColourFormat->Blue.Shift;

                //pRender_DumpScreen = Render_DumpScreen4;        

				if (CurrentGraphicsFormat.BPP!=8)
				{
					Render_TrueColourRGB_Setup();
				}
				else
				{
					Render_Paletted_Setup();
				}
#if 0                
				if (InitialiseRender(ScreenWidth, ScreenHeight, CurrentGraphicsFormat.BPP))
				{
					return TRUE;
				}
#endif
				Render_SetGraphicsBufferColourFormat(&BufferColourFormat, ScreenWidth, ScreenHeight);

				return TRUE;
        }

        return FALSE;
}

//**************************************************************************************

// Speed engine


static unsigned long PreviousTime=0;
//int Host_LockSpeed = FALSE;
unsigned long TimeError = 0;
extern BOOL DoNotScanKeyboard;
#include "OnScreenDisplay.h"


bool bFirstTiming = true;

/* constantly updated */
unsigned long MinTime = 0;
/* constantly updated */
unsigned long MaxTime = 0;
/* time of last */
unsigned long LastTime = 0;
/* cumulative time for last MAX_TIMINGS frames */
unsigned long CumulativeTime = 0;
/* number of timings */
unsigned long NumTimings = 0;

#define MAX_TIMINGS 100
unsigned long LastTimings[MAX_TIMINGS];
unsigned long TimingLastIndex = 0;

int fps_counter = 0;
unsigned long fps_timer = 0;
int fps;


void Host_Throttle(void)
{
	unsigned long	Time;

	if ((Host_LockSpeed) && ((!(FDD_GetFlags(0) & FDD_FLAGS_DRIVE_READY)) || (!SpeedDrive)))
	{

		/* use this to throttle speed */
		unsigned long	TimeDifference;

		int nPercent = 100;
		unsigned int FrameTimeMS = (20 * 100) / nPercent;

		do
		{
			/* get current time */
			Time = timeGetTime();

			/* calc time difference */
			TimeDifference = Time - (PreviousTime-TimeError);
		}
		while (TimeDifference < FrameTimeMS);

		TimeError = (TimeDifference - FrameTimeMS) % FrameTimeMS;

	}
	else
	{
		Time = timeGetTime();
	}

	//FPS Update
	UpdateTiming(Time - PreviousTime);

	PreviousTime = Time;

  /* disc drive light indicator*/
  // DoDriveLEDIndicator(0, FDD_LED_GetState(0));

	
}


void ResetTiming()
{

	// NOTE: FPS reporting, if going from fast to slow it's fairly quick to report the value
	// if it's going from slow to fast you can see it as it increases. It takes a few frames to get there.
	// We can also see that if you try for 200% you can see if it's achieved it or not.

	NumTimings = 0;
	bFirstTiming = true;
	TimingLastIndex = 0;
	MinTime = 0;
	MaxTime = 0;
	LastTime = 0;
	CumulativeTime = 0;
}

void UpdateTiming(unsigned long Diff)
{
	/* update min and max */
	if (Diff < MinTime)
	{
		MinTime = Diff;
	}
	else if (Diff > MaxTime)
	{
		MaxTime = Diff;
	}

	/* update index */
	TimingLastIndex++;
	if (TimingLastIndex >= MAX_TIMINGS)
	{
		TimingLastIndex = 0;
	}

	/* remove a timing from the cumulative timings */
	if (NumTimings == MAX_TIMINGS)
	{
		CumulativeTime -= LastTimings[TimingLastIndex];
	}
	else
	{
		NumTimings++;
	}

	/* store this */
	LastTimings[TimingLastIndex] = Diff;
	/* and update cumulative */
	CumulativeTime += LastTimings[TimingLastIndex];
}


unsigned long GetAverageTime()
{
	if (NumTimings == 0)
		return 0;

	return CumulativeTime / NumTimings;
}
int GetAverageSpeed(void)
{
	unsigned long Time = GetAverageTime();

	/*
	100% -> 20
	50% -> 40
	*/

	if (Time == 0)
		return 0;

	return (20 * 100) / (Time);
}

void CountFps(void)
{
	unsigned long Time = timeGetTime();

	if ((Time - fps_timer) > 1000)
	{
		fps = fps_counter;
		fps_counter = 0;
		fps_timer = Time;
	}

	fps_counter +=1;
}